/**
  ******************************************************************************
  * @file    py32f4xx_hal.h
  * @author  MCU Application Team
  * @brief   This file contains all the functions prototypes for the HAL
  *          module driver.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PY32F4xx_HAL_H
#define __PY32F4xx_HAL_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "py32f410_hal_conf.h"

/** @addtogroup PY32F410_HAL_Driver
  * @{
  */

/** @addtogroup HAL
  * @{
  */

/* Exported constants --------------------------------------------------------*/

/** @defgroup HAL_Exported_Constants HAL Exported Constants
  * @{
  */

/** @defgroup HAL_TICK_FREQ Tick Frequency
  * @{
  */
#define HAL_TICK_FREQ_10HZ          100U
#define HAL_TICK_FREQ_100HZ         10U
#define HAL_TICK_FREQ_1KHZ          1U
#define HAL_TICK_FREQ_DEFAULT       HAL_TICK_FREQ_1KHZ
  
/**
  * @}
  */
/**
  * @}
  */

/* Exported types ------------------------------------------------------------*/

/* Exported variables --------------------------------------------------------*/
/** @addtogroup HAL_Exported_Variables
  * @{
  */
extern uint32_t uwTickPrio;
extern uint32_t uwTickFreq;
/**
  * @}
  */

/* SYSCFG Exported Constants -------------------------------------------------*/
/** @defgroup SYSCFG_Exported_Constants SYSCFG Exported Constants
  * @{
  */
  
/** @defgroup SYSCFG_BootMode Boot Mode
  * @{
  */
#define SYSCFG_BOOT_MAINFLASH          0x00000000U
#define SYSCFG_BOOT_SYSTEMFLASH        SYSCFG_CFGR1_MEM_MODE_0
#define SYSCFG_BOOT_SRAM               (SYSCFG_CFGR1_MEM_MODE_1 | SYSCFG_CFGR1_MEM_MODE_0)
/**
  * @}
  */

/** @defgroup SYSCFG_GPIOx_Pins GPIOx Pins
  * @{
  */
#define SYSCFG_GPIOA_PIN_0                    SYSCFG_COMP_ANA2ENR_PA0_ENA2
#define SYSCFG_GPIOA_PIN_1                    SYSCFG_COMP_ANA2ENR_PA1_ENA2
#define SYSCFG_GPIOA_PIN_2                    SYSCFG_COMP_ANA2ENR_PA2_ENA2
#define SYSCFG_GPIOA_PIN_3                    SYSCFG_COMP_ANA2ENR_PA3_ENA2
#define SYSCFG_GPIOA_PIN_4                    SYSCFG_COMP_ANA2ENR_PA4_ENA2
#define SYSCFG_GPIOA_PIN_5                    SYSCFG_COMP_ANA2ENR_PA5_ENA2
#define SYSCFG_GPIOA_PIN_9                    SYSCFG_COMP_ANA2ENR_PA9_ENA2
#define SYSCFG_GPIOB_PIN_1                    SYSCFG_COMP_ANA2ENR_PB1_ENA2
/**
  * @}
  */

/**
  * @}
  */

/* Exported macro ------------------------------------------------------------*/
/** @defgroup HAL_Exported_Macros HAL Exported Macros
  * @{
  */

/** @defgroup DBGMCU_Freeze_Unfreeze Freeze Unfreeze Peripherals in Debug mode
  * @brief   Freeze/Unfreeze Peripherals in Debug mode
  * Note: On devices PY32F4xx
  *       Debug registers DBGMCU_IDCODE and DBGMCU_CR are accessible only in
  *       debug mode (not accessible by the user software in normal mode).
  *       Refer to errata sheet of these devices for more details.
  * @{
  */

/**
  * @brief  IWDG Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_IWDG_STOP)
#define __HAL_DBGMCU_FREEZE_IWDG()            SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_IWDG_STOP)
#define __HAL_DBGMCU_UNFREEZE_IWDG()          CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_IWDG_STOP)
#endif

/**
  * @brief  WWDG Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_WWDG_STOP)
#define __HAL_DBGMCU_FREEZE_WWDG()            SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_WWDG_STOP)
#define __HAL_DBGMCU_UNFREEZE_WWDG()          CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_WWDG_STOP)
#endif

/**
  * @brief  TIM1 Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_TIM1_STOP)
#define __HAL_DBGMCU_FREEZE_TIM1()            SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM1_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM1()          CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM1_STOP)
#endif

/**
  * @brief  TIM2 Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_TIM2_STOP)
#define __HAL_DBGMCU_FREEZE_TIM2()            SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM2_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM2()          CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM2_STOP)
#endif

/**
  * @brief  TIM3 Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_TIM3_STOP)
#define __HAL_DBGMCU_FREEZE_TIM3()            SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM3_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM3()          CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM3_STOP)
#endif

/**
  * @brief  TIM4 Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_TIM4_STOP)
#define __HAL_DBGMCU_FREEZE_TIM4()            SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM4_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM4()          CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM4_STOP)
#endif

/**
  * @brief  I2C1 Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_I2C1_SMBUS_TIMEOUT)
#define __HAL_DBGMCU_FREEZE_I2C1_TIMEOUT()    SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_I2C1_SMBUS_TIMEOUT)
#define __HAL_DBGMCU_UNFREEZE_I2C1_TIMEOUT()  CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_I2C1_SMBUS_TIMEOUT)
#endif

/**
  * @brief  I2C2 Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_I2C2_SMBUS_TIMEOUT)
#define __HAL_DBGMCU_FREEZE_I2C2_TIMEOUT()    SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_I2C2_SMBUS_TIMEOUT)
#define __HAL_DBGMCU_UNFREEZE_I2C2_TIMEOUT()  CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_I2C2_SMBUS_TIMEOUT)
#endif

/**
  * @brief  TIM6 Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_TIM6_STOP)
#define __HAL_DBGMCU_FREEZE_TIM6()            SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM6_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM6()          CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM6_STOP)
#endif

/**
  * @brief  TIM7 Peripherals Debug mode
  */
#if defined (DBGMCU_CR1_DBG_TIM7_STOP)
#define __HAL_DBGMCU_FREEZE_TIM7()            SET_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM7_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM7()          CLEAR_BIT(DBGMCU->CR1, DBGMCU_CR1_DBG_TIM7_STOP)
#endif

/**
  * @brief  TIM15 Peripherals Debug mode
  */
#if defined (DBGMCU_CR2_DBG_TIM15_STOP)
#define __HAL_DBGMCU_FREEZE_TIM15()            SET_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_TIM15_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM15()          CLEAR_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_TIM15_STOP)
#endif

/**
  * @brief  TIM16 Peripherals Debug mode
  */
#if defined (DBGMCU_CR2_DBG_TIM16_STOP)
#define __HAL_DBGMCU_FREEZE_TIM16()            SET_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_TIM16_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM16()          CLEAR_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_TIM16_STOP)
#endif

/**
  * @brief  TIM17 Peripherals Debug mode
  */
#if defined (DBGMCU_CR2_DBG_TIM17_STOP)
#define __HAL_DBGMCU_FREEZE_TIM17()            SET_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_TIM17_STOP)
#define __HAL_DBGMCU_UNFREEZE_TIM17()          CLEAR_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_TIM17_STOP)
#endif

/**
  * @brief  LPTIM Peripherals Debug mode
  */
#if defined (DBGMCU_CR2_DBG_LPTIM_STOP)
#define __HAL_DBGMCU_FREEZE_LPTIM()            SET_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_LPTIM_STOP)
#define __HAL_DBGMCU_UNFREEZE_LPTIM()          CLEAR_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_LPTIM_STOP)
#endif

/**
  * @brief  PWM1 Peripherals Debug mode
  */
#if defined (DBGMCU_CR2_DBG_PWM1_STOP)
#define __HAL_DBGMCU_FREEZE_PWM1()            SET_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_PWM1_STOP)
#define __HAL_DBGMCU_UNFREEZE_PWM1()          CLEAR_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_PWM1_STOP)
#endif

/**
  * @brief  PWM2 Peripherals Debug mode
  */
#if defined (DBGMCU_CR2_DBG_PWM2_STOP)
#define __HAL_DBGMCU_FREEZE_PWM2()            SET_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_PWM2_STOP)
#define __HAL_DBGMCU_UNFREEZE_PWM2()          CLEAR_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_PWM2_STOP)
#endif

/**
  * @brief  PWM3 Peripherals Debug mode
  */
#if defined (DBGMCU_CR2_DBG_PWM3_STOP)
#define __HAL_DBGMCU_FREEZE_PWM3()            SET_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_PWM3_STOP)
#define __HAL_DBGMCU_UNFREEZE_PWM3()          CLEAR_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_PWM3_STOP)
#endif

/**
  * @brief  PWM4 Peripherals Debug mode
  */
#if defined (DBGMCU_CR2_DBG_PWM4_STOP)
#define __HAL_DBGMCU_FREEZE_PWM4()            SET_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_PWM4_STOP)
#define __HAL_DBGMCU_UNFREEZE_PWM4()          CLEAR_BIT(DBGMCU->CR2, DBGMCU_CR2_DBG_PWM4_STOP)
#endif

/**
  * @}
  */

/** @defgroup SYSCFG_Exported_Macros SYSCFG Exported Macros
  * @{
  */

/** @brief  SYSCFG Break Cortex-M4 Lockup lock.
  *         Enable and lock the connection of Cortex-M4 LOCKUP (Hardfault) output to TIM1/8/15/16/17 Break input.
  * @note   The selected configuration is locked and can be unlocked only by system reset.
  */
#define __HAL_SYSCFG_BREAK_LOCKUP_LOCK()     SET_BIT(SYSCFG->CFGR[1], SYSCFG_CFGR2_CLL)

/** @brief  SYSCFG Break PVD lock.
  *         Enable and lock the PVD connection to Timer1/8/15/16/17 Break input, as well as the PVDE and PLS[2:0] in the PWR_CR2 register.
  * @note   The selected configuration is locked and can be unlocked only by system reset.
  */
#define __HAL_SYSCFG_BREAK_PVD_LOCK()        SET_BIT(SYSCFG->CFGR[1], SYSCFG_CFGR2_PVDL)

/** @brief  Enable I2C1 Filter.
  */
#define __HAL_SYSCFG_I2C1_FILTER_ENABLE()     SET_BIT(SYSCFG->CFGR[0], SYSCFG_CFGR1_I2C1_FLTEN)

/** @brief  Disable I2C1 Filter.
  */
#define __HAL_SYSCFG_I2C1_FILTER_DISABLE()     CLEAR_BIT(SYSCFG->CFGR[0], SYSCFG_CFGR1_I2C1_FLTEN)

/** @brief  Enable I2C2 Filter.
  */
#define __HAL_SYSCFG_I2C2_FILTER_ENABLE()     SET_BIT(SYSCFG->CFGR[0], SYSCFG_CFGR1_I2C2_FLTEN)

/** @brief  Disable I2C2 Filter.
  */
#define __HAL_SYSCFG_I2C2_FILTER_DISABLE()     CLEAR_BIT(SYSCFG->CFGR[0], SYSCFG_CFGR1_I2C2_FLTEN)
/**
  * @}
  */

/**
  * @}
  */
/* Private macros ------------------------------------------------------------*/
/** @defgroup HAL_Private_Macros HAL Private Macros
  * @{
  */
#define IS_TICKFREQ(FREQ) (((FREQ) == HAL_TICK_FREQ_10HZ)  || \
                           ((FREQ) == HAL_TICK_FREQ_100HZ) || \
                           ((FREQ) == HAL_TICK_FREQ_1KHZ))
                           
/**
  * @}
  */

/* SYSCFG Private macros -----------------------------------------------------*/
/** @defgroup SYSCFG_Private_Macros SYSCFG Private Macros
  * @{
  */
#define IS_GPIOX_PIN(__PIN__) (((__PIN__) == SYSCFG_GPIOA_PIN_0)  || \
                               ((__PIN__) == SYSCFG_GPIOA_PIN_1)  || \
                               ((__PIN__) == SYSCFG_GPIOA_PIN_2)  || \
                               ((__PIN__) == SYSCFG_GPIOA_PIN_3)  || \
                               ((__PIN__) == SYSCFG_GPIOA_PIN_4)  || \
                               ((__PIN__) == SYSCFG_GPIOA_PIN_5)  || \
                               ((__PIN__) == SYSCFG_GPIOA_PIN_9)  || \
                               ((__PIN__) == SYSCFG_GPIOB_PIN_1))
/**
  * @}
  */

/* DBGMCU Private macros -----------------------------------------------------*/
/** @defgroup DBGMCU_Private_Macros DBGMCU Private Macros
  * @{
  */

/**
  * @}
  */

/* Exported functions --------------------------------------------------------*/
/** @addtogroup HAL_Exported_Functions
  * @{
  */
/** @addtogroup HAL_Exported_Functions_Group1
  * @{
  */
/* Initialization and de-initialization functions  ******************************/
HAL_StatusTypeDef HAL_Init(void);
HAL_StatusTypeDef HAL_DeInit(void);
void HAL_MspInit(void);
void HAL_MspDeInit(void);
HAL_StatusTypeDef HAL_InitTick(uint32_t TickPriority);
/**
  * @}
  */

/** @addtogroup HAL_Exported_Functions_Group2
  * @{
  */
/* Peripheral Control functions  ************************************************/
void HAL_IncTick(void);
void HAL_Delay(uint32_t Delay);
uint32_t HAL_GetTick(void);
uint32_t HAL_GetTickPrio(void);
HAL_StatusTypeDef HAL_SetTickFreq(uint32_t Freq);
uint32_t HAL_GetTickFreq(void);
void HAL_SuspendTick(void);
void HAL_ResumeTick(void);
uint32_t HAL_GetHalVersion(void);
uint32_t HAL_GetREVID(void);
uint32_t HAL_GetDEVID(void);
uint32_t HAL_GetUIDw0(void);
uint32_t HAL_GetUIDw1(void);
uint32_t HAL_GetUIDw2(void);
uint32_t HAL_GetUIDw3(void);
/**
  * @}
  */
  
/** @addtogroup HAL_Exported_Functions_Group3
  * @{
  */
void HAL_DBGMCU_EnableDBGSleepMode(void);
void HAL_DBGMCU_DisableDBGSleepMode(void);
void HAL_DBGMCU_EnableDBGStopMode(void);
void HAL_DBGMCU_DisableDBGStopMode(void);
#if defined(PWR_STANDBY_SURPORT)
void HAL_DBGMCU_EnableDBGStandbyMode(void);
void HAL_DBGMCU_DisableDBGStandbyMode(void);
#endif
/**
  * @}
  */
  
/** @addtogroup HAL_Exported_Functions_Group4
  * @{
  */
void HAL_SYSCFG_SetRemapMemory(uint32_t Memory);
uint32_t HAL_SYSCFG_GetRemapMemory(void);
void HAL_SYSCFG_EnableGPIONoiseFilter(GPIO_TypeDef *GPIOx,uint16_t GPIO_Pin);
void HAL_SYSCFG_DisableGPIONoiseFilter(GPIO_TypeDef *GPIOx,uint16_t GPIO_Pin);
void HAL_SYSCFG_EnableGPIOAnalog2(uint32_t GPIOx_Pin);
void HAL_SYSCFG_DisableGPIOAnalog2(uint32_t GPIOx_Pin);
/**
  * @}
  */

/**
  * @}
  */
/* Private types -------------------------------------------------------------*/

/* Private constants ---------------------------------------------------------*/
/** @defgroup HAL_Private_Constants HAL Private Constants
  * @{
  */
/**
  * @}
  */
/* Private macros ------------------------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif /* __PY32F4xx_HAL_H */

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
